package org.pgusb.usb4allLib;


import exceptions.Usb4allException;

public class BootLoader extends Usb4allDevice{

	//	skeleton
	private static final int IN_ENDPOINT_TYPE = Usb4allDevice.BULK_IN; //Replace with the prefered In Endpoint Type.
	private static final int OUT_ENDPOINT_TYPE = Usb4allDevice.BULK_OUT; //Replace with the prefered Out Endpoint Type.
	
	public BootLoader(String moduleName){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		this.moduleName=moduleName;
	}
	
	public BootLoader(){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		moduleName="boot"; //Put the name of the firmware module.
	}

	public int getVersion(){
		//BootDataPacket resp = new BootDataPacket();
	    //genero payload con mensaje de read version para el bootloader
		BootDataPacket bdp = new BootDataPacket(BootDataPacket.READ_VERSION,0,4,null);
		
		byte[] command = new byte[1];
		byte[] version = null;
		command[0]=0x00;
		try {
			send(bdp.getPacket());
			version = receive(4);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("La version es:" +" "+ version[0] +  " "+ version[1] +" "+ version[2] +" "+ version[3]);
		return 1;
	}
	
	private class BootDataPacket {
		private static final int BOOT_EP_SIZE = 64;
		public static final int OVER_HEAD = 5 ; //<CMD><LEN><ADR:3>
		private static final int DATA_SIZE = BOOT_EP_SIZE - OVER_HEAD;
		public static final byte READ_VERSION = 0x00;
		public static final byte READ_FLASH = 0x01;
		public static final byte WRITE_FLASH = 0x02;
		public static final byte ERASE_FLASH = 0x03;
		public static final byte READ_EEDATA = 0x04;
		public static final byte WRITE_EEDATA = 0x05;
		public static final byte READ_CONFIG = 0x06;
		public static final byte WRITE_CONFIG = 0x07;
		public static final byte UPDATE_LED = 0x32;
		public static final byte RESET = (byte)0xFF;
		
		byte cmd;
		byte len;
		byte adr_low;
		byte adr_high;
		byte adr_upper;
		byte[] data;
		
		public BootDataPacket(byte cmd, int address,int len, byte[] data) {
			super();
			//si el bootdatapacket es de writeFlash, lo relleno con FF hasta llegar a longitud de 16
			if (cmd==WRITE_FLASH && len!=16){
				this.len=16;
				this.data = new byte[16];
				for(int i=0;i<16;i++){
					if (i<len){
						this.data[i]=data[i];
					}
					else {
						this.data[i]=(byte)0xff;
					}
				}
			}
			else {
				this.len=(byte)len;
				this.data = data;
			}
			this.cmd = cmd;
			adr_low = (byte)(address % 256);
			adr_high = (byte)((address / 256) % 256);
			adr_upper = (byte)( address / 65536);
			
		}
		public BootDataPacket(){
			
		}
		public BootDataPacket(int dataSize){
			data = new byte[dataSize];
			len = (byte)dataSize;
		}
		
		public byte[] getPacket(){
			
			byte[] packet;
			if (data!=null){
				if (cmd==READ_VERSION) {
					packet = new byte[data.length];
				}
				else {
					packet = new byte[data.length+ OVER_HEAD];
				}
			}
			else packet = new byte[this.len];
			if (len>0) packet[0] = cmd;
			if (len>1) packet[1] = len;
			if (len>2) packet[2] = adr_low;
			if (len>3) packet[3] = adr_high;
			if (len>4) packet[4] = adr_upper;
			if (len>5 && data!=null){
				for (int i=0; i<data.length; i++){
					packet[i+OVER_HEAD] = data[i];
				}
			}
			return packet;
		}
		
		public void printBinData(){
			byte[] c=this.getPacket();
			//System.out.println("en binario: ");
			for (int i=0;i<c.length;i++){
				String s = Integer.toHexString(Byte.valueOf(c[i]));
				if (s.length()>1) s = s.substring(s.length()-2);
				else s = "0"+s;
				System.out.print(s +" ");
			}
			System.out.println();
		}
		
		public byte[] getCommand(){
			byte[] packet;
			if (data!=null){
				if (data[0]==READ_VERSION) packet = new byte[data.length];
				else packet = new byte[data.length+ OVER_HEAD];
			}
			else packet = new byte[5];
			/*// da problemas al generar read que quiero leer menos de 5 bytes
			if (len>0) packet[0] = cmd;
			if (len>1) packet[1] = len;
			if (len>2) packet[2] = adr_low;
			if (len>3) packet[3] = adr_high;
			if (len>4) packet[4] = adr_upper;
			*/
			packet[0] = cmd;
			packet[1] = len;
			packet[2] = adr_low;
			packet[3] = adr_high;
			packet[4] = adr_upper;
			
			return packet;
		}
		
		public void parse(byte[] s){
			data=s;
			if (s!=null){
				cmd = s[0];
				if (s.length>1) len = s[1];
				if (s.length>2) adr_low = s[2];
				if (s.length>3) adr_high = s[3];
				if (s.length>4) adr_upper = s[4];
				if (s.length>OVER_HEAD){
					data = new byte[s.length-OVER_HEAD];
					for (int i=0; i<s.length - OVER_HEAD; i++){
						data[i]=s[i+OVER_HEAD];
					}
				}
			}
		}

		public byte getAdr_high() {
			return adr_high;
		}

		public void setAdr_high(byte adr_high) {
			this.adr_high = adr_high;
		}

		public byte getAdr_low() {
			return adr_low;
		}

		public void setAdr_low(byte adr_low) {
			this.adr_low = adr_low;
		}

		public byte getAdr_upper() {
			return adr_upper;
		}

		public void setAdr_upper(byte adr_upper) {
			this.adr_upper = adr_upper;
		}

		public byte getCmd() {
			return cmd;
		}

		public void setCmd(byte cmd) {
			this.cmd = cmd;
		}

		public byte[] getData() {
			return data;
		}

		public void setData(byte[] data) {
			this.data = data;
			
		}

		public byte getLen() {
			return len;
		}

		public void setLen(byte len) {
			this.len = len;
		}
	}

	public byte[] readFlash(int address,int len) {
		System.out.println("Read de direccion:" + Integer.toHexString(address));
		BootDataPacket resp = new BootDataPacket();
	    BootDataPacket bdp = new BootDataPacket(BootDataPacket.READ_FLASH,address,len,null);
	    int recvLength=len+BootDataPacket.OVER_HEAD;
	    byte[] data;
	    try {
			send(bdp.getPacket());
			data = receive(recvLength);
			resp.parse(data);
			System.out.print("Bytes Leidos: ");
			resp.printBinData();
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return resp.getData();
	}
	
	public void reset() {
		//genero payload con mensaje de reset para el bootloader
		BootDataPacket bdp = new BootDataPacket(BootDataPacket.RESET,0,4,null);
		try {
			send(bdp.getCommand());
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public boolean writeFlash(int address,byte[] data) {
		System.out.println("Write de direccion:" + Integer.toHexString(address));
		BootDataPacket resp = new BootDataPacket();
		boolean respb=false;
		byte[] dataResp=null;
		if (data!=null && data.length<=16){
			int len=data.length;
	    	BootDataPacket bdp = new BootDataPacket(BootDataPacket.WRITE_FLASH,address,len,data);
	    	int recvLength=1;
	    	try {
				send(bdp.getPacket());
				//System.out.print("Bytes Enviados: ");
				//bdp.printBinData();
	    		dataResp = receive(recvLength);
				resp.parse(dataResp);
				//System.out.print("Bytes Leidos: ");
				//resp.printBinData();
				if (resp.getData()[0]==BootDataPacket.WRITE_FLASH){
					respb = true;
				}
			} catch (Usb4allException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return respb;
	}
	
	public boolean eraseFlash(int address) {
		System.out.println("Erase de direccion:" + Integer.toHexString(address));
		boolean respb=false;
		BootDataPacket resp = new BootDataPacket();
	    BootDataPacket bdp = new BootDataPacket(BootDataPacket.ERASE_FLASH,address,5,null);
	    int recvLength=1;
	    byte[] dataResp=null;
	    try {
			send(bdp.getPacket());
			dataResp = receive(recvLength);
			resp.parse(dataResp);
			//System.out.print("Bytes Leidos: ");
			//resp.printBinData();
			if (resp.getData()[0]==BootDataPacket.ERASE_FLASH){
				respb = true;
			}
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return respb;
	}
}
